/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogFilterBlock;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AstronomicalClockBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.AverageValueBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.MaxMinBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.PWMBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.StopWatchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.hardware.Logo6;
import DE.siemens.ad.pdraw.simulation.ActualValueVisitor;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFParameterItem;

public class ActualValueVisitorV7
extends ActualValueVisitor {
    WiringDiagram fWD = ((LogoDrawing)Application.getInstance().getActiveApplicationSurface().getEditor().getView().getModel()).getWiringDiagram();

    public Object visit(AnalogFilterBlock analogFilterBlock) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        Block topBlock = this.fWD.getOutestBlock(analogFilterBlock);
        if (topBlock instanceof UDFBlock) {
            aqValue = this.getOnlineTestTextForUDF(analogFilterBlock, (UDFBlock)topBlock, "Aq", aqValue);
        }
        return aqValue;
    }

    protected void ignoreBytes(int count) {
    }

    public Object visit(AverageValueBlock averageValueBlock) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        Block topBlock = this.fWD.getOutestBlock(averageValueBlock);
        if (topBlock instanceof UDFBlock) {
            aqValue = this.getOnlineTestTextForUDF(averageValueBlock, (UDFBlock)topBlock, "Aq", aqValue);
        }
        return aqValue;
    }

    public Object visit(AstronomicalClockBlock astronomicalClockBlock) {
        TimeUnit TR = this.parseTimer();
        TimeUnit TS = this.parseTimer();
        String trValue = TR.getTimeAsString();
        String tsValue = TS.getTimeAsString();
        Block topBlock = this.fWD.getOutestBlock(astronomicalClockBlock);
        if (topBlock instanceof UDFBlock) {
            trValue = this.getOnlineTestTextForUDF(astronomicalClockBlock, (UDFBlock)topBlock, "TR", trValue);
            tsValue = this.getOnlineTestTextForUDF(astronomicalClockBlock, (UDFBlock)topBlock, "TS", tsValue);
        }
        return trValue + "\n" + tsValue;
    }

    public Object visit(MaxMinBlock maxMinBlock) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        Block topBlock = this.fWD.getOutestBlock(maxMinBlock);
        if (topBlock instanceof UDFBlock) {
            aqValue = this.getOnlineTestTextForUDF(maxMinBlock, (UDFBlock)topBlock, "Aq", aqValue);
        }
        return aqValue;
    }

    public Object visit(StopWatchBlock stopWatchBlock) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq &= 0xFFFF);
        Block topBlock = this.fWD.getOutestBlock(stopWatchBlock);
        if (topBlock instanceof UDFBlock) {
            aqValue = this.getOnlineTestTextForUDF(stopWatchBlock, (UDFBlock)topBlock, "Aq", aqValue);
        }
        return aqValue;
    }

    public Object visit(AnalogComparatorBlock analogComparatorBlock) {
        Block topBlock = this.fWD.getOutestBlock(analogComparatorBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(analogComparatorBlock);
        }
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        int ay = this.parseAnalogValue();
        int delta = this.parseAnalogValue();
        String axValue = Integer.toString(ax);
        String ayValue = Integer.toString(ay);
        String deltaValue = Integer.toString(delta);
        this.ignoreBytes(4);
        axValue = this.getOnlineTestTextForUDF(analogComparatorBlock, (UDFBlock)topBlock, "Ax", axValue);
        ayValue = this.getOnlineTestTextForUDF(analogComparatorBlock, (UDFBlock)topBlock, "Ay", ayValue);
        deltaValue = this.getOnlineTestTextForUDF(analogComparatorBlock, (UDFBlock)topBlock, "AxAy", deltaValue);
        return axValue + "\n" + ayValue + "\n" + deltaValue;
    }

    public Object visit(AnalogDeltaTriggerBlock analogDeltaTriggerBlock) {
        Block topBlock = this.fWD.getOutestBlock(analogDeltaTriggerBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(analogDeltaTriggerBlock);
        }
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        String axValue = Double.toString(ax);
        this.ignoreBytes(2);
        axValue = this.getOnlineTestTextForUDF(analogDeltaTriggerBlock, (UDFBlock)topBlock, "Ax", axValue);
        return axValue;
    }

    public Object visit(AnalogMathsBlock analogMathsBlock) {
        Block topBlock = this.fWD.getOutestBlock(analogMathsBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(analogMathsBlock);
        }
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        this.ignoreBytes(2);
        aqValue = this.getOnlineTestTextForUDF(analogMathsBlock, (UDFBlock)topBlock, "Aq", aqValue);
        return aqValue;
    }

    public Object visit(AnalogMuxBlock analogMuxBlock) {
        Block topBlock = this.fWD.getOutestBlock(analogMuxBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(analogMuxBlock);
        }
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        this.ignoreBytes(2);
        aqValue = this.getOnlineTestTextForUDF(analogMuxBlock, (UDFBlock)topBlock, "Aq", aqValue);
        return aqValue;
    }

    public Object visit(AnalogTriggerBlock analogTriggerBlock) {
        Block topBlock = this.fWD.getOutestBlock(analogTriggerBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(analogTriggerBlock);
        }
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        String axValue = Double.toString(ax);
        this.ignoreBytes(2);
        axValue = this.getOnlineTestTextForUDF(analogTriggerBlock, (UDFBlock)topBlock, "Ax", axValue);
        return axValue;
    }

    public Object visit(AnalogWatchdogBlock analogWatchdogBlock) {
        Block topBlock = this.fWD.getOutestBlock(analogWatchdogBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(analogWatchdogBlock);
        }
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        int aen = this.parseAnalogValue();
        if (!(analogWatchdogBlock.getHardware() instanceof Logo6)) {
            this.ignoreBytes(4);
        } else {
            int temp = ax;
            ax = aen;
            aen = temp;
            this.ignoreBytes(2);
        }
        String axValue = Double.toString(ax);
        String aenValue = Double.toString(aen);
        axValue = this.getOnlineTestTextForUDF(analogWatchdogBlock, (UDFBlock)topBlock, "Ax", axValue);
        aenValue = this.getOnlineTestTextForUDF(analogWatchdogBlock, (UDFBlock)topBlock, "Aen", aenValue);
        StringBuffer value = new StringBuffer();
        value.append(axValue).append("\n").append(aenValue);
        return value.toString();
    }

    public Object visit(AsymPulseGeneratorBlock asymPulseGeneratorBlock) {
        Block topBlock = this.fWD.getOutestBlock(asymPulseGeneratorBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(asymPulseGeneratorBlock);
        }
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(asymPulseGeneratorBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(ComfortSwitchBlock comfortSwitchBlock) {
        Block topBlock = this.fWD.getOutestBlock(comfortSwitchBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(comfortSwitchBlock);
        }
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(comfortSwitchBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(CounterBlock counterBlock) {
        Block topBlock = this.fWD.getOutestBlock(counterBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(counterBlock);
        }
        int cnt = 0;
        cnt += this.getByte();
        cnt += this.getByte() << 8;
        cnt += this.getByte() << 16;
        String cntValue = Integer.toString(cnt += this.getByte() << 24);
        this.ignoreBytes(6);
        cntValue = this.getOnlineTestTextForUDF(counterBlock, (UDFBlock)topBlock, "Cnt", cntValue);
        return cntValue;
    }

    public Object visit(HoursCounterBlock hoursCounterBlock) {
        Block topBlock = this.fWD.getOutestBlock(hoursCounterBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(hoursCounterBlock);
        }
        this.ignoreBytes(1);
        int mn = 0;
        mn += this.getByte();
        mn += this.getByte() << 8;
        mn += this.getByte() << 16;
        mn += (this.getByte() & 0x3F) << 24;
        int ot = 0;
        ot += this.getByte();
        ot += this.getByte() << 8;
        ot += this.getByte() << 16;
        this.ignoreBytes(2);
        String mnValue = this.formatHoursCounterTime(mn);
        String otValue = this.formatHoursCounterTime(ot += this.getByte() << 24);
        mnValue = this.getOnlineTestTextForUDF(hoursCounterBlock, (UDFBlock)topBlock, "MN", mnValue);
        otValue = this.getOnlineTestTextForUDF(hoursCounterBlock, (UDFBlock)topBlock, "OT", otValue);
        return mnValue + "\n" + otValue;
    }

    public Object visit(MathDetectionBlock mathDetectionBlock) {
        Block topBlock = this.fWD.getOutestBlock(mathDetectionBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(mathDetectionBlock);
        }
        int state = this.getByte();
        this.ignoreBytes(2);
        String oeValue = (state & 1) > 0 ? "Overflow" : "No Error";
        String zeValue = (state & 2) > 0 ? "Zero_div" : "No Error";
        oeValue = this.getOnlineTestTextForUDF(mathDetectionBlock, (UDFBlock)topBlock, "OE", oeValue);
        zeValue = this.getOnlineTestTextForUDF(mathDetectionBlock, (UDFBlock)topBlock, "ZE", zeValue);
        return oeValue + "\n" + zeValue;
    }

    public Object visit(OffDelayBlock offDelayBlock) {
        Block topBlock = this.fWD.getOutestBlock(offDelayBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(offDelayBlock);
        }
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(offDelayBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(OnDelayBlock onDelayBlock) {
        Block topBlock = this.fWD.getOutestBlock(onDelayBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(onDelayBlock);
        }
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(onDelayBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(OnOffDelayBlock onOffDelayBlock) {
        Block topBlock = this.fWD.getOutestBlock(onOffDelayBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(onOffDelayBlock);
        }
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(onOffDelayBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(RandomBlock randomBlock) {
        Block topBlock = this.fWD.getOutestBlock(randomBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(randomBlock);
        }
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(randomBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(PIDBlock block) {
        Block topBlock = this.fWD.getOutestBlock(block);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(block);
        }
        this.ignoreBytes(9);
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        int pv = this.parseAnalogValue();
        block.setOnlineTestAQ(aq);
        block.setOnlineTestPV(pv);
        this.ignoreBytes(2);
        aqValue = this.getOnlineTestTextForUDF(block, (UDFBlock)topBlock, "Aq", aqValue);
        return aqValue;
    }

    public Object visit(PWMBlock block) {
        Block topBlock = this.fWD.getOutestBlock(block);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(block);
        }
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        this.parseTimer();
        this.ignoreBytes(2);
        String axtValue = this.getOnlineTestTextForUDF(block, (UDFBlock)topBlock, "Ax_T", Double.toString(ax));
        return axtValue;
    }

    public Object visit(RampControlBlock rampControlBlock) {
        Block topBlock = this.fWD.getOutestBlock(rampControlBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(rampControlBlock);
        }
        this.ignoreBytes(2);
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        this.ignoreBytes(10);
        aqValue = this.getOnlineTestTextForUDF(rampControlBlock, (UDFBlock)topBlock, "Aq", aqValue);
        return aqValue;
    }

    public Object visit(RetentiveOnDelayBlock retentiveOnDelayBlock) {
        Block topBlock = this.fWD.getOutestBlock(retentiveOnDelayBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(retentiveOnDelayBlock);
        }
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(retentiveOnDelayBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(SoftkeyBlock softkeyBlock) {
        Block topBlock = this.fWD.getOutestBlock(softkeyBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(softkeyBlock);
        }
        int state = this.getByte();
        String stateString = state > 0 ? "On" : "Off";
        this.ignoreBytes(3);
        stateString = this.getOnlineTestTextForUDF(softkeyBlock, (UDFBlock)topBlock, "State", stateString);
        return stateString;
    }

    public Object visit(StairsSwitchBlock stairsSwitchBlock) {
        Block topBlock = this.fWD.getOutestBlock(stairsSwitchBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(stairsSwitchBlock);
        }
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(stairsSwitchBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(TriggerBlock triggerBlock) {
        Block topBlock = this.fWD.getOutestBlock(triggerBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(triggerBlock);
        }
        this.ignoreBytes(2);
        int fa = 0;
        fa += this.getByte();
        String faValue = Integer.toString(fa += this.getByte() << 8);
        this.ignoreBytes(4);
        faValue = this.getOnlineTestTextForUDF(triggerBlock, (UDFBlock)topBlock, "fa", faValue);
        return faValue;
    }

    public Object visit(WipingRelayBlock wipingRelayBlock) {
        Block topBlock = this.fWD.getOutestBlock(wipingRelayBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(wipingRelayBlock);
        }
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(wipingRelayBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(WipingRelayPECBlock wipingRelayPECBlock) {
        Block topBlock = this.fWD.getOutestBlock(wipingRelayPECBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(wipingRelayPECBlock);
        }
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        String taValue = timeUnit.getTimeAsString();
        taValue = this.getOnlineTestTextForUDF(wipingRelayPECBlock, (UDFBlock)topBlock, "Ta", taValue);
        return taValue;
    }

    public Object visit(AmplifierBlock amplifierBlock) {
        Block topBlock = this.fWD.getOutestBlock(amplifierBlock);
        if (!(topBlock instanceof UDFBlock)) {
            return super.visit(amplifierBlock);
        }
        int ax = this.parseAnalogValue();
        String axValue = Integer.toString(ax);
        axValue = this.getOnlineTestTextForUDF(amplifierBlock, (UDFBlock)topBlock, "Ax", axValue);
        this.ignoreBytes(2);
        return axValue;
    }

    private String getUDFParaItemIdentifier(Block watchedBlock, Block topBlock, String identifier) {
        String ret = null;
        ParameterItemList blockParaItemList = watchedBlock.getParameter().getParameterItems();
        ParameterItem blockParaItem = blockParaItemList.getParameterItem(identifier);
        BlockParameter blockParameter = watchedBlock.getParameter();
        UDFParameterItem UDFParaItem = ((UDFBlock)topBlock).getUDFParaItemByRootParaItem(blockParameter, blockParaItem.getParameterNumber());
        if (UDFParaItem != null) {
            ret = UDFParaItem.getIdentifier() + "=";
        }
        return ret;
    }

    private String getOnlineTestTextForUDF(Block watchedBlock, UDFBlock topBlock, String paraIdentifier, String value) {
        String ret = "";
        String UDFIdenifier = this.getUDFParaItemIdentifier(watchedBlock, topBlock, paraIdentifier);
        if (UDFIdenifier != null) {
            ret = UDFIdenifier + value;
        }
        return ret;
    }
}

